/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.jsfcl.data;

import com.icesoft.faces.component.selectinputtext.SelectInputText;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;

public class AutoComplete
implements Serializable {
    private static Logger log = Logger.getLogger("com.icesoft.faces.component.selectinputtext");
    private List matchesList = new ArrayList();
    private List dataList = new ArrayList();
    public static final Comparator LABEL_COMPARATOR = new Comparator(){
        String s1;
        String s2;

        public int compare(Object o1, Object o2) {
            this.s1 = ((SelectItem)o1).getLabel();
            this.s2 = o2 instanceof SelectItem ? ((SelectItem)o2).getLabel() : o2.toString();
            return this.s1.compareToIgnoreCase(this.s2);
        }
    };

    public List getMatchesList() {
        return this.matchesList;
    }

    public void updateList(ValueChangeEvent event) {
        SelectInputText autoComplete;
        this.setMatches(event);
        if (event.getComponent() instanceof SelectInputText && (autoComplete = (SelectInputText)event.getComponent()).getSelectedItem() != null) {
            try {
                Object selectedObject = autoComplete.getSelectedItem().getValue();
                log.log(Level.FINEST, " selected object" + selectedObject);
            }
            catch (Exception e) {
                log.log(Level.FINEST, "Cannot update list " + e.getMessage());
            }
        }
    }

    private void setMatches(ValueChangeEvent event) {
        Object searchWord = event.getNewValue();
        int maxMatches = ((SelectInputText)event.getComponent()).getRows();
        ArrayList matchList = new ArrayList(maxMatches);
        this.getDataList();
        try {
            int insert = Collections.binarySearch(this.dataList, searchWord, LABEL_COMPARATOR);
            if (insert < 0) {
                insert = Math.abs(insert) - 1;
            }
            for (int i = 0; i < maxMatches && insert + i < this.dataList.size() && i < maxMatches; ++i) {
                matchList.add(this.dataList.get(insert + i));
            }
        }
        catch (Throwable e) {
            log.log(Level.FINEST, "Error finding autocomplete matches" + e.getMessage());
        }
        if (this.matchesList != null) {
            this.matchesList.clear();
            this.matchesList = null;
        }
        this.matchesList = matchList;
    }

    public List getDataList() {
        if (this.dataList.isEmpty()) {
            this.dataList.add(new SelectItem((Object)"mac"));
            this.dataList.add(new SelectItem((Object)"linux"));
            this.dataList.add(new SelectItem((Object)"windows"));
        }
        return this.dataList;
    }

    public void setDataList(List dataList) {
        this.dataList = dataList;
    }
}

