/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.chartData.interfaces.IAxisChartDataSet;
import org.krysalis.jcharts.imageMap.ImageMapNotSupportedException;

abstract class AreaChart {
    AreaChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) {
        int n;
        int n2;
        if (axisChart.getImageMap() != null) {
            throw new ImageMapNotSupportedException("HTML client-side image maps are not supported on Area Charts.");
        }
        float f = axisChart.getXAxis().getTickStart();
        GeneralPath[] generalPathArray = new GeneralPath[iAxisChartDataSet.getNumberOfDataSets()];
        for (n2 = 0; n2 < generalPathArray.length; ++n2) {
            generalPathArray[n2] = new GeneralPath();
            generalPathArray[n2].moveTo(f, axisChart.getYAxis().getZeroLineCoordinate());
            generalPathArray[n2].lineTo(f, axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iAxisChartDataSet.getValue(n2, 0), axisChart.getYAxis().getScaleCalculator().getMinValue()));
        }
        for (n2 = 1; n2 < iAxisChartDataSet.getNumberOfDataItems(); ++n2) {
            f += axisChart.getXAxis().getScalePixelWidth();
            for (n = 0; n < generalPathArray.length; ++n) {
                generalPathArray[n].lineTo(f, axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iAxisChartDataSet.getValue(n, n2), axisChart.getYAxis().getScaleCalculator().getMinValue()));
            }
        }
        Area[] areaArray = new Area[generalPathArray.length];
        for (n = 0; n < generalPathArray.length; ++n) {
            generalPathArray[n].lineTo(f, axisChart.getYAxis().getZeroLineCoordinate());
            generalPathArray[n].closePath();
            areaArray[n] = new Area(generalPathArray[n]);
        }
        Graphics2D graphics2D = axisChart.getGraphics2D();
        for (int i = 0; i < areaArray.length; ++i) {
            graphics2D.setPaint(iAxisChartDataSet.getPaint(i));
            graphics2D.fill(areaArray[i]);
        }
    }
}

