class WineriesController < ApplicationController
  # GET /wineries
  # GET /wineries.xml
  def index
    @wineries = Winery.all

    respond_to do |format|
      format.html # index.html.erb
      format.xml  { render :xml => @wineries }
    end
  end

  # GET /wineries/1
  # GET /wineries/1.xml
  def show
    @winery = Winery.find(params[:id])

    respond_to do |format|
      format.html # show.html.erb
      format.xml  { render :xml => @winery }
    end
  end

  # GET /wineries/new
  # GET /wineries/new.xml
  def new
    @winery = Winery.new

    respond_to do |format|
      format.html # new.html.erb
      format.xml  { render :xml => @winery }
    end
  end

  # GET /wineries/1/edit
  def edit
    @winery = Winery.find(params[:id])
  end

  # POST /wineries
  # POST /wineries.xml
  def create
    @winery = Winery.new(params[:winery])

    respond_to do |format|
      if @winery.save
        flash[:notice] = 'Winery was successfully created.'
        format.html { redirect_to(@winery) }
        format.xml  { render :xml => @winery, :status => :created, :location => @winery }
      else
        format.html { render :action => "new" }
        format.xml  { render :xml => @winery.errors, :status => :unprocessable_entity }
      end
    end
  end

  # PUT /wineries/1
  # PUT /wineries/1.xml
  def update
    @winery = Winery.find(params[:id])

    respond_to do |format|
      if @winery.update_attributes(params[:winery])
        flash[:notice] = 'Winery was successfully updated.'
        format.html { redirect_to(@winery) }
        format.xml  { head :ok }
      else
        format.html { render :action => "edit" }
        format.xml  { render :xml => @winery.errors, :status => :unprocessable_entity }
      end
    end
  end

  # DELETE /wineries/1
  # DELETE /wineries/1.xml
  def destroy
    @winery = Winery.find(params[:id])
    @winery.destroy

    respond_to do |format|
      format.html { redirect_to(wineries_url) }
      format.xml  { head :ok }
    end
  end
end
