class Wine < ActiveRecord::Base

  belongs_to :winery
  has_and_belongs_to_many :cellars
  
  has_attached_file :photo, 
    :styles => {
      :tiny => "50x50#",
      :thumb => "100x100#"
    }

  validates_presence_of :name, :price, :winery_id
  validates_numericality_of :price, :allow_nil => true
  validates_format_of :year, :with => /\d{4}/, :allow_nil => true
  
  #validates_length_of wg. 255 zeichenbegrenzung  
  
  def self.search(query)
    query.empty? ? [] : find (:all, :conditions => ["name LIKE ?", "%#{query}%"])
  end

end
