class Winery < ActiveRecord::Base

  has_many :wines, :dependent => :destroy

  validates_presence_of :name, :address, :growing_area
  validates_uniqueness_of :name
  
  def name_and_growing_area
    "#{name} (#{growing_area})"
  end

end
