//
//  UPNCalculator.h
//  UPNCalculator
//
//  Created by Kai Brüning on 20.7.11.
//  Copyright 2011 Kai Brüning. All rights reserved.
//

#import <Foundation/Foundation.h>

// Modelklasse für einen Taschenrechner mit umgekehrter polnischer Notation (bekannt von den HP-Taschenrechnern)

typedef enum UPNOperator {
    upnNoOp,
    upnPlus,
    upnMinus,
    upnTimes,
    upnDiv,
    upnExchange
} UPNOperator;

// Die Stapeltiefe ist begrenzt, um testbare Grenzen zu haben. Der tatsächliche Grenzwert kann natürlich viel größer sein.
enum {
    upnMaxStackDepth = 10
};

@interface UPNCalculator : NSObject

// Fügt 'number' dem Stapel hinzu. Wirft eine Ausnahme im Falle eines Stapelüberlaufs.
- (void) push:(NSNumber*)number;

// Entfernt das oberste Stapelelement und gibt es zurück. Wirft eine Ausnahme im Falle eines Stapelunterlaufs.
- (NSNumber*) pop;

// Entfernt die Operanden für 'op' vom Stapel, führt 'op' aus und fügt das Ergebnis dem Stapel hinzu.
- (void) perform:(UPNOperator)op;

// Gibt das Stapelelment an 'index' zurück, ohne den Stapel zu ändern. Index 0 ist das obere Stapelende.
// Wirft eine Ausnahme falls 'index' jenseits der Stapeltiefe liegt.
- (NSNumber*) numberAtIndex:(NSUInteger)index;

// Gibt die Zahl der Stapelelemente zurück.
@property (readonly) NSUInteger stackDepth;

@end

// Name für die Ausnahmen, die von UPNCalculator geworfen werden.
extern NSString* const UPNCalculatorException;
