//
//  UPNCalculator.m
//  UPNCalculator
//
//  Created by Kai Brüning on 20.7.11.
//  Copyright 2011 Kai Brüning. All rights reserved.
//

#import "UPNCalculator.h"

@implementation UPNCalculator
// Neu im Löwen: ivars können (endlich!) in der Implementation definiert werden.
// (allerdings unter Mac OS nur unter der modernen Laufzeitumgebung, also für 64 bit)
{
    NSMutableArray* stack_;
}

- (id) init
{
    if ((self = [super init]) != nil) {
        stack_ = [[NSMutableArray alloc] init];
    }
    
    return self;
}

- (void) push:(NSNumber*)number
{
    NSParameterAssert (number);

    if (self.stackDepth >= upnMaxStackDepth)
        [NSException raise:UPNCalculatorException format:@"Stack overflow at %i elements", upnMaxStackDepth];
    
    [stack_ addObject:number];
}

- (NSNumber*) pop
{
    if (self.stackDepth == 0)
        [NSException raise:UPNCalculatorException format:@"Stack underflow"];

    NSNumber* value = stack_.lastObject;
    [stack_ removeLastObject];
    return value;
}

- (void) perform:(UPNOperator)op
{
    switch (op) {
        case upnNoOp:
            break;
        case upnPlus: {
            NSNumber* v1 = [self pop];
            NSNumber* v2 = [self pop];
            [self push:[NSNumber numberWithDouble:v2.doubleValue + v1.doubleValue]];
            break;
        }
        case upnMinus: {
            NSNumber* v1 = [self pop];
            NSNumber* v2 = [self pop];
            [self push:[NSNumber numberWithDouble:v2.doubleValue - v1.doubleValue]];
            break;
        }
        case upnTimes: {
            NSNumber* v1 = [self pop];
            NSNumber* v2 = [self pop];
            [self push:[NSNumber numberWithDouble:v2.doubleValue * v1.doubleValue]];
            break;
        }
        case upnDiv: {
            NSNumber* v1 = [self pop];
            NSNumber* v2 = [self pop];
            [self push:[NSNumber numberWithDouble:v2.doubleValue / v1.doubleValue]];
            break;
        }
        case upnExchange: {
            NSNumber* v1 = [self pop];
            NSNumber* v2 = [self pop];
            [self push:v1];
            [self push:v2];
            break;
        }
        default:
            [NSException raise:UPNCalculatorException format:@"Unknown operation (%i)", op];
    }
}

- (NSNumber*) numberAtIndex:(NSUInteger)index
{
    NSUInteger stackDepth = self.stackDepth;
    if (index >= stackDepth)
        [NSException raise:UPNCalculatorException format:@"Index (%i) beyond end of stack (%i)", index, stackDepth];
    
    return [stack_ objectAtIndex:stackDepth - index - 1];
}

- (NSUInteger) stackDepth
{
    return stack_.count;
}

@end

NSString* const UPNCalculatorException = @"UPNCalculatorException";