//
//  UPNCalculatorOperationTests.m
//  UPNCalculator
//
//  Created by Kai Brüning on 20.7.11.
//  Copyright 2011 Kai Brüning. All rights reserved.
//

#import "UPNCalculatorOperationTests.h"
#import "UPNCalculator.h"


@implementation UPNCalculatorOperationTests
{
    UPNCalculator*  calculator_;
}

- (void) setUp
{
    [super setUp];
    
    // Set-up code here.
    calculator_ = [[UPNCalculator alloc] init];
    [calculator_ push:[NSNumber numberWithDouble:5.0]];
    [calculator_ push:[NSNumber numberWithDouble:2.0]];
}

- (void) testNoOp
{
    [calculator_ perform:upnNoOp];
    STAssertEquals       (calculator_.stackDepth, (NSUInteger)2, @"unexpected stack depth after performing no-op");
    STAssertEqualObjects ([calculator_ numberAtIndex:0], [NSNumber numberWithDouble:2.0], @"unexpected result after no-op");
    STAssertEqualObjects ([calculator_ numberAtIndex:1], [NSNumber numberWithDouble:5.0], @"unexpected result after no-op");
}

- (void) testPlus
{
    [calculator_ perform:upnPlus];
    STAssertEquals       (calculator_.stackDepth, (NSUInteger)1, @"unexpected stack depth after performing plus");
    STAssertEqualObjects ([calculator_ numberAtIndex:0], [NSNumber numberWithDouble:7.0], @"unexpected result after plus");
    
    // Der folgende Test ist streng genommen überflüssig, da -perform: auf -pop zurückgreift, und dessen Verhalten ist
    // bereits getestet. Andererseits könnte die Implementation von -perform: geändert werden, deshalb kann der
    // zusätzliche Test nicht schaden.
    STAssertThrowsSpecificNamed ([calculator_ perform:upnPlus], NSException, UPNCalculatorException, @"stack underflow during perform should throw");
}

- (void) testMinus
{
    [calculator_ perform:upnMinus];
    STAssertEquals       (calculator_.stackDepth, (NSUInteger)1, @"unexpected stack depth after performing minus");
    STAssertEqualObjects ([calculator_ numberAtIndex:0], [NSNumber numberWithDouble:3.0], @"unexpected result after minus");
    
    STAssertThrowsSpecificNamed ([calculator_ perform:upnMinus], NSException, UPNCalculatorException, @"stack underflow during perform should throw");
}

- (void) testTimes
{
    [calculator_ perform:upnTimes];
    STAssertEquals       (calculator_.stackDepth, (NSUInteger)1, @"unexpected stack depth after performing times");
    STAssertEqualObjects ([calculator_ numberAtIndex:0], [NSNumber numberWithDouble:10.0], @"unexpected result after times");
    
    STAssertThrowsSpecificNamed ([calculator_ perform:upnTimes], NSException, UPNCalculatorException, @"stack underflow during perform should throw");
}

- (void) testDiv
{
    [calculator_ perform:upnDiv];
    STAssertEquals       (calculator_.stackDepth, (NSUInteger)1, @"unexpected stack depth after performing div");
    STAssertEqualObjects ([calculator_ numberAtIndex:0], [NSNumber numberWithDouble:2.5], @"unexpected result after div");

    STAssertThrowsSpecificNamed ([calculator_ perform:upnDiv], NSException, UPNCalculatorException, @"stack underflow during perform should throw");
}

- (void) testExchange
{
    [calculator_ perform:upnExchange];
    STAssertEquals       (calculator_.stackDepth, (NSUInteger)2, @"unexpected stack depth after performing exchange");
    STAssertEqualObjects ([calculator_ numberAtIndex:0], [NSNumber numberWithDouble:5.0], @"unexpected result after exchange");
    STAssertEqualObjects ([calculator_ numberAtIndex:1], [NSNumber numberWithDouble:2.0], @"unexpected result after exchange");
}

- (void) testInvalidOp
{
    STAssertThrowsSpecificNamed ([calculator_ perform:4711], NSException, UPNCalculatorException, @"perform with invalid operation should throw");
}

@end
