//
//  UPNCalculatorStackTests.m
//  UPNCalculatorTests
//
//  Created by Kai Brüning on 20.7.11.
//  Copyright 2011 Kai Brüning. All rights reserved.
//

#import "UPNCalculatorStackTests.h"
#import "UPNCalculator.h"


@implementation UPNCalculatorStackTests
{
    UPNCalculator*  calculator_;
}

- (void) setUp
{
    [super setUp];
    
    // Set-up code here.
    calculator_ = [[UPNCalculator alloc] init];
}

- (void) testEins {
	UPNCalculator* calculator = [[UPNCalculator alloc] init];
	STAssertNotNil (calculator, @"couldn’t create a calculator");
    STAssertEquals (calculator.stackDepth, (NSUInteger)0, @"newly created calculator should have empty stack");
}

- (void) testPush {
    [calculator_ push:[NSNumber numberWithDouble:1.0]];
    STAssertEquals       (calculator_.stackDepth, 1ul, nil);
    STAssertEqualObjects ([calculator_ numberAtIndex:0], [NSNumber numberWithDouble:1.0], nil);
}

- (void) testPushPop
{
    // Push something for a successful pop
    [calculator_ push:[NSNumber numberWithDouble:1.0]];
    
    NSNumber* tosValue = [calculator_ pop];
    STAssertEquals       (calculator_.stackDepth, (NSUInteger)0, @"unexpected stack depth after pop");
    STAssertEqualObjects (tosValue, [NSNumber numberWithDouble:1.0], @"unexpected popped value");

    // Push a few more numbers.
    [calculator_ push:[NSNumber numberWithDouble:1.0]];
    [calculator_ push:[NSNumber numberWithDouble:2.0]];
    [calculator_ push:[NSNumber numberWithDouble:3.0]];
    [calculator_ push:[NSNumber numberWithDouble:4.0]];
    STAssertEquals       (calculator_.stackDepth, (NSUInteger)4, @"unexpected stack depth after multiple pushes");
    STAssertEqualObjects ([calculator_ numberAtIndex:0], [NSNumber numberWithDouble:4.0], @"unexpected value on stack");
    STAssertEqualObjects ([calculator_ numberAtIndex:1], [NSNumber numberWithDouble:3.0], @"unexpected value on stack");
    STAssertEqualObjects ([calculator_ numberAtIndex:2], [NSNumber numberWithDouble:2.0], @"unexpected value on stack");
    STAssertEqualObjects ([calculator_ numberAtIndex:3], [NSNumber numberWithDouble:1.0], @"unexpected value on stack");
    
    STAssertEqualObjects ([calculator_ pop], [NSNumber numberWithDouble:4.0], @"unexpected popped value");
    STAssertEqualObjects ([calculator_ pop], [NSNumber numberWithDouble:3.0], @"unexpected popped value");
    STAssertEquals       (calculator_.stackDepth, (NSUInteger)2, @"unexpected stack depth after multiple pop");

    // Mix pops and pushs
    [calculator_ push:[NSNumber numberWithDouble:3.14]];
    
    STAssertEqualObjects ([calculator_ pop], [NSNumber numberWithDouble:3.14], @"unexpected popped value");
    STAssertEqualObjects ([calculator_ pop], [NSNumber numberWithDouble:2.0], @"unexpected popped value");
    STAssertEqualObjects ([calculator_ pop], [NSNumber numberWithDouble:1.0], @"unexpected popped value");
    STAssertEquals       (calculator_.stackDepth, (NSUInteger)0, @"unexpected stack depth after multiple pop");
}

- (void) testStackExceptions
{
    // Pop of empty stack must throw.
    STAssertThrowsSpecificNamed ([calculator_ pop], NSException, UPNCalculatorException, @"pop with empty stack should throw");
    
    // Fill the stack to capcity.
    for (int i = 0; i < upnMaxStackDepth; ++i) {
        STAssertNoThrow ([calculator_ push:[NSNumber numberWithDouble:1.0]], @"unexpected exception");
    }
    // Next push must throw.
    STAssertThrowsSpecificNamed ([calculator_ push:[NSNumber numberWithDouble:1.0]], NSException, UPNCalculatorException, @"push with filled stack should throw");
}

@end
