/*
	Dieses Skript dient zur einfachen Ueberpruefung der Geschwindigkeit
	der aktuellen Internetverbindung des Nutzers. Abhaenig von dem
	Ergebnis werden in der HTML-Seite Bilder mit einer hoehern oder 
	niedrigen Aufloesung genutzt. Optional werden unterschiedliche
	CCS-Dateien eingebunden.
*/
maciQoS = function() {
	MIN_HI_SPEED_KBPS = 500;        // Mindestgeschwindigkeit in kbps
	REF_PIXEL_SIZE    = 50135;      // Groesse vom Testbild in Byte // 50029
	HIGH_RES_CSS      = "hres.css" + "?r=" + Math.random();; // CSS mit hoher Aufloesung
	LOW_RES_CSS       = "lres.css" + "?r=" + Math.random();; // CSS mit niedriger Aufloesung
	EXP_TIME_MIN      = 1;          // Gueltigkeit des Tests in Minuten
	LARGE_WIN_WIDTH   = 1025;       // Vorgabe Fenstergroesse - Breite
	LARGE_WIN_HEIGHT  = 800;        // Vorgabe Fenstergroesse - Hoehe

	var $that         = this;
	
	/*
		Der URL des Testbilds. Um den Cache des Browsers auszuschalten,
		wird eine Zufallszahl als Parameter angehaengt
	*/
	this.imageAddr = "https://s3.amazonaws.com/cdeutsch/50K" + "?r=" + Math.random(); 
	
	this.startTime = (new Date()).getTime(); // Die aktuelle Zeit in Millisekunden
	this.endTime   = 0;
	this.highSpeed = false;
	this.speedKbps = 0;

	this.winScreenWidth    = window.screen.width;     // Breite des Fenster
	this.winScreenHeight   = window.screen.height;    // Hoehe des Fenster
	this.winDevicePixelRatio = window.devicePixelRatio; // Pixel / dips

	// Wenn der Browser nicht kann oder will
	if(this.winDevicePixelRatio === undefined) {
		this.winDevicePixelRatio = 1;
	}
	
	this.testSpeed = true;      // Test durchfuehren

	// Gibt es schon Testergebnisse und wenn ja, wie alt sind diese?
	try {
		var maciDataSet = JSON.parse(localStorage.getItem('maci'));
		if (maciDataSet !== null) {
			// Sind die Testergebnisse noch gueltig?
			if ((new Date()).getTime() < maciDataSet.exp) {
				this.speedKbps = maciDataSet.kbps;
				this.testSpeed = false; // Es muss keinen Test gemacht werden
			}
		}
	} catch( e ) { }

	if (this.testSpeed) {
		// Die Geschwindigkeit wird nun mit dem Testbild gemessen
		this.download = new Image();

		this.download.onload = function() {
			// Callback wird nach dem Beenden des Ladevorgangs aufgerufen
			$that.endTime = (new Date()).getTime();
			$that.calcResults();
		}
	
		this.download.onerror = function () {
			// Falls ein Fehler aufgetreten ist
			$that.endTime = $that.startTime - 1;
			$that.calcResults();
		};
		
		// Startet den Download des Testbilds
		this.download.src = this.imageAddr;
	} else {
		// kein erneuter Download, gespeicherte Werte werden verwendet
		$that.evaluateResults();
	}
}

/* 
	Berechnen der Geschwindigkeit des Downloads in kbps.
*/
maciQoS.prototype.calcResults = function() {
	var duration   = ((this.endTime - this.startTime) / 1000);     // Dauer in Sekunden
	var bitsLoaded = REF_PIXEL_SIZE * 8;                           // Downloadgröße in Bit
	this.speedKbps  = ((bitsLoaded / duration) / 1024).toFixed(2); // Kilobit/s

	// Der Messwert in kbps wird gespeichert. Fuer aeltere Browser musste ein Cookie
	// benutzt werden
	try {
		var maciDataSet = {
			kbps: this.speedKbps,
			exp: (new Date() ).getTime() + (EXP_TIME_MIN * 60000)
		};
		localStorage.setItem('maci', JSON.stringify(maciDataSet));
	} catch( e ) { }

	this.evaluateResults();
}

/* 
	Bewerten des Testergebnisses. Ist es eine gute oder schlechte Anbindung.
*/
maciQoS.prototype.evaluateResults = function() {
	if(this.speedKbps >= MIN_HI_SPEED_KBPS) {
		this.highSpeed = true;
	} else {
		this.highSpeed = false;
	}
}


/*
	Setzen des src Attributs von jedem img Tag im HTML Dokument.
	Die img tags haben dazu die Attribute hres und lres. Wenn es eine ausreichend 
	gute Verbindung ist wird der URI aus dem hres in das src Attribute geschrieben
	und wenn nicht der lres URI.
*/
maciQoS.prototype.setImageSource = function() {
	var img = document.getElementsByTagName("img");
	var setSource = "lres";
	
	/*
		Wenn DevicePixelRatio > 1 (Retina Display) oder das Fenster groß genug ist:
		alle Bilder in hoher Aufloesung laden.
		Wird mit <body onload="maciQoS.setImageSource();"> oder
		$(document).ready(handler) bei der Nutzung von JQuery eingebunden.
		Fuer JQuery Mobile muss der pageinit Event genutzt werden.
	*/
	if((this.winDevicePixelRatio > 1 || (this.winScreenHeight >= LARGE_WIN_HEIGHT && this.winScreenWidth >= LARGE_WIN_WIDTH)) && this.highSpeed) {
		setSource = "hres";
	}
	
	for( var i = 0; i < img.length;i++ ) {
		var tmp = img[i].getAttribute(setSource);
		img[i].src = tmp;

		if (img[i].style.display !== 'inline' ) {
			img[i].style.display = 'inline'; // und sichtbar muessen die Bilder wieder werden
		}
	}
}

/* 
	Wer lieber unterschiedliche Stylesheets je nach Leitungsqualitaet
	nutzen will, kann diese Funktion alternativ oder zusaetzlich aufrufen
*/
maciQoS.prototype.loadCSS = function() {
	var head = document.getElementsByTagName('head')[0];
	var link = document.createElement('link');
	link.rel = 'stylesheet';
	link.type = 'text/css';
	
	if(this.highSpeed) {
		link.href = HIGH_RES_CSS;
		head.appendChild(link);
	} else {
		link.href = LOW_RES_CSS;
		head.appendChild(link);
	}
}