//
//  RBAppDelegate.m
//  Rezeptbuch
//
//  Created by Robert Böhnke on 10/30/12.
//  Copyright (c) 2012 Robert Böhnke. All rights reserved.
//

#import "RBAppDelegate.h"

#import "RBRecipeListViewController.h"

#import "RBConstants.h"

@implementation RBAppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
    [[NSUserDefaults standardUserDefaults] registerDefaults:@{
        RBFontSize: @"normal",
        RBOpenDyslexicEnabled: @NO
    }];

    self.window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];

    UINavigationController *navigationController = [[UINavigationController alloc] init];
    navigationController.viewControllers = @[
        [[RBRecipeListViewController alloc] init]
    ];

    UIViewController *aboutController = [[UIViewController alloc] initWithNibName:@"RBAboutViewController"
                                                                           bundle:nil];
    aboutController.title = NSLocalizedString(@"Über", <#comment#>);

    UITabBarController *tabBarController = [[UITabBarController alloc] init];
    tabBarController.viewControllers = @[
        navigationController,
        aboutController
    ];

    self.window.rootViewController = tabBarController;

    [self.window makeKeyAndVisible];
    return YES;
}

@end
