//
//  RBRecipe.m
//  Rezeptbuch
//
//  Created by Robert Böhnke on 11/21/12.
//  Copyright (c) 2012 Robert Böhnke. All rights reserved.
//

#import "RBRecipe.h"

#import "RBConstants.h"

@interface RBRecipe ()

@property (readwrite, copy) NSString *title;
@property (readwrite, copy) NSString *filename;
@property (readwrite, assign) RBRecipeHealthinessValue healthiness;

@end

@implementation RBRecipe

- (id)initWithDictionary:(NSDictionary *)dictionary
{
    self = [super init];
    if (self) {
        self.title    = dictionary[RBRecipeTitle];
        self.filename = dictionary[RBRecipeFilename];

        NSString *healthiness = dictionary[RBRecipeHealthiness];

        if ([healthiness isEqualToString:@"RBRecipeHealthinessGood"]) {
            self.healthiness = RBRecipeHealthinessGood;
        } else if ([healthiness isEqualToString:@"RBRecipeHealthinessAverage"]) {
            self.healthiness = RBRecipeHealthinessAverage;
        } else {
            self.healthiness = RBRecipeHealthinessBad;
        }
    }
    return self;
}

@end
