//
//  RBRecipeViewController.m
//  Rezeptbuch
//
//  Created by Robert Böhnke on 11/21/12.
//  Copyright (c) 2012 Robert Böhnke. All rights reserved.
//

#import "RBRecipeViewController.h"

#import "RBConstants.h"
#import "RBStarSlider.h"

@interface RBRecipeViewController () <UIWebViewDelegate>

@property (readwrite, strong) UIWebView *webView;
@property (readwrite, strong) RBStarSlider *starSlider;

@property (readwrite, strong) RBRecipe  *recipe;

- (void)updateDisplayOptions;
- (void)setClassOfBody:(NSString *)className;

@end

@implementation RBRecipeViewController

#pragma mark UIViewController

- (id)initWithRecipe:(RBRecipe *)recipe
{
    self = [super init];
    if (self) {
        self.recipe = recipe;
    }
    return self;
}

- (void)loadView
{
    [super loadView];

    CGRect starSliderRect, webViewRect;

    CGRectDivide(self.view.bounds, &starSliderRect, &webViewRect, 55, CGRectMinYEdge);

    self.starSlider = [[RBStarSlider alloc] initWithFrame:starSliderRect];
    self.starSlider.autoresizingMask = UIViewAutoresizingFlexibleWidth;
    [self.view addSubview:self.starSlider];

    self.webView = [[UIWebView alloc] initWithFrame:webViewRect];
    self.webView.delegate = self;
    self.webView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
    [self.view addSubview:self.webView];
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];

    __weak RBRecipeViewController *weakSelf = self;
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        NSError *error;

        NSString *path = [NSBundle.mainBundle.bundlePath stringByAppendingPathComponent:weakSelf.recipe.filename];
        NSString *html = [NSString stringWithContentsOfFile:path
                                                   encoding:NSUTF8StringEncoding
                                                      error:&error];

        if (!html) {
            NSLog(@"Encountered error when loading recipe: %@", error.localizedDescription);
        }

        dispatch_async(dispatch_get_main_queue(), ^{
            [weakSelf.webView loadHTMLString:html baseURL:NSBundle.mainBundle.resourceURL];
        });
    });
}

#pragma mark UIWebViewDelegate

- (void)webViewDidFinishLoad:(UIWebView *)webView
{
    [self updateDisplayOptions];
}

#pragma mark RBRecipeViewController

- (void)updateDisplayOptions
{
    NSMutableString *className = [NSMutableString string];

    NSString *fontSize = [NSUserDefaults.standardUserDefaults stringForKey:RBFontSize];

    [className appendString:fontSize];

    if ([NSUserDefaults.standardUserDefaults boolForKey:RBOpenDyslexicEnabled]) {
        [className appendString:@" dyslexic"];
    }

    [self setClassOfBody:className];
}

- (void)setClassOfBody:(NSString *)className
{
    NSString *scriptTemplate = @"var body = document.getElementsByTagName('body')[0]; body.className = '%@';";

    [self.webView stringByEvaluatingJavaScriptFromString:[NSString stringWithFormat:scriptTemplate, className]];
}

@end
