//
//  CTPDetailViewController.m
//  PhotoViewer
//
//  Created by Richard Kurz on 12.06.13.
//  Copyright (c) 2013 Nobody. No rights reserved.
//

#import "CTPDetailViewController.h"


@interface CTPDetailViewController ()

@property (nonatomic, weak) IBOutlet UIImageView* imageView;

@end


@implementation CTPDetailViewController


- (void) configureView
{
  if ([self.detailItem isKindOfClass: [UIImage class]])
  {
    self.imageView.image = self.detailItem;
  }
}


- (void) viewDidLoad
{
  [super viewDidLoad];
  
  [self configureView];
}


- (void) setDetailItem: (id) newDetailItem
{
  if (_detailItem != newDetailItem)
  {
    _detailItem = newDetailItem;
    
    [self configureView];
  }
}


@end
