using UnityEngine;
using System.Collections;

public class DuckClass : MonoBehaviour
{
	public float speed = 1; // Startgeschwindigkeit
	public GameObject effectPrefab; // wenn die Ente verschwindet
	private GameObject player; // um mit dem Spieler zu interagieren
	private float timeOfLastChangeDirection = 0; // interne Variable merkt sich wann der letzte Richtungswechsel war
	public float timeToChangeDirection = 5; // wann wird es Zeit fuer eine neue Richtungsaenderung?
	private Material duckMaterial;  // manchmal ist es praktisch, sich oft benoetigte Elemente gleich zu Anfang in eine Variable zu holen. 
	
	// Use this for initialization
	void Start ()
	{
		player = GameObject.Find("Player");
		duckMaterial = transform.FindChild ("rubberduckmesh").renderer.material;  // die 'Haut' der Ente
	}
	
	// Update is called once per frame
	void Update ()
	{
		// Distanz ermitteln und entsprechend reagieren
		float distanceToPlayer = Vector3.Distance (transform.position, player.transform.position);
		if (distanceToPlayer > 30) {  // herumwandern
			speed = Time.timeSinceLevelLoad / 20;
			if (Time.timeSinceLevelLoad - timeOfLastChangeDirection > timeToChangeDirection) {
				timeOfLastChangeDirection = Time.timeSinceLevelLoad;
				transform.LookAt (new Vector3 (Random.Range (-500, 500), 1, Random.Range (-500, 500)));
			}
		} else if (distanceToPlayer < 2.5f) { // beruehrt Spieler, game over
			if (!player.GetComponent<PlayerClass> ().isGameOver) {
				player.GetComponent<PlayerClass> ().gameOver (false);
			}
			return;
		} else { // verfolge Spieler
			speed = 15 + Time.timeSinceLevelLoad / 20;
			transform.LookAt (player.transform);
		}
		
		// Ente ist neu ausgerichtet, jetzt noch nach 'vorwaerts' bewegen
		CharacterController controller = GetComponent<CharacterController> ();
		Vector3 forward = transform.TransformDirection (Vector3.forward);
		controller.SimpleMove (forward * speed);
	}
	
	// der CharacterController hat einen Collider und der ist mit etwas kollidiert, was in der Variablen 'hit' uebergeben wird
	void OnControllerColliderHit (ControllerColliderHit hit)
	{
		if (hit.gameObject.name == "ColorBall") {
			if (duckMaterial.color == Color.white)  // beim ersten Treffer einfach die Ballfarbe uebertragen
				duckMaterial.color = hit.gameObject.renderer.material.color;
			else {  // beim zweiten und dritten Treffer die Farbe des Balles mit der Farbe der Ente mixen
				Color currentDuckColor = duckMaterial.color;
				Color colorBallColor = hit.gameObject.renderer.material.color;
				duckMaterial.color = new Vector4 (Mathf.Max (currentDuckColor.r, colorBallColor.r), Mathf.Max (currentDuckColor.g, colorBallColor.g), Mathf.Max (currentDuckColor.b, colorBallColor.b), 1);
			}
			// den Farbball entfernen
			hit.gameObject.GetComponent<ColorBallClass> ().die ();
			
			if (duckMaterial.color == Color.white)  // wenn die Ente mit drei verschiedenen Farben getroffen wurde, verschwindet sie
				killMe ();
		}
	}
	
	// den Effect erzeugen und die Ente verschwinden lassen
	public void killMe ()
	{
		Instantiate (effectPrefab, transform.position, Quaternion.identity);
		Destroy (this.gameObject);
	}
}
