using UnityEngine;
using System.Collections;

public class PlayerClass: MonoBehaviour
{
	public float speed = 30f;  // Vorwaertsgeschwindigkeit. 'public' heisst, der Wert kann im Editor ueberschrieben werden
	public float rotateSpeed = 3.0f;  // Drehgeschwindigkeit
	public GameObject duckContainer; // wird in Update gebraucht. Im Editor hier das entsprechende Objekt aus der Szene reinziehen
	public GUIStyle customLabel;  // im Editor die Schriftparameter der GUI anpassen
	public bool isGameOver = false;  // dient zur Orientierung fuer die Zeit, wenn das Spiel aus ist aber die Ende-Routine noch nicht abgewickelt wurde
	private bool startTextIsShowing = true;  // am Anfang wird ein Orientierungstext eingeblendet
	public GameObject startScreen;  // der Orientierungstext (alternativ: Ein GameObject bestehend aus Text, Hintergrund, Rahmen, etc.)
	public GameObject colorBallPrefab; // die Schablone fuer den Ball
	public int throwsAvailable = 5;  // so viele Baelle koennen maximal zur gleichen Zeit in der Szene sein
	public Color[] colorTable;  // so deklariert man ein eindimensionales Array. Dies muss noch mit "new..." erzeugt werden

	// Use this for initialization
	void Start ()
	{
		colorTable = new Color[3] {Color.green, Color.red, Color.blue};  // so erzeugt man ein vorher deklariertes Array
//		GameObject throwBallButton = GameObject.Find("ThrowButton");
//		Vector3 leftBottomCoordinate = Camera.main.ViewportToWorldPoint(new Vector3(0,0,Camera.main.nearClipPlane));
//		throwBallButton.transform.position = new Vector3(leftBottomCoordinate.x + 0.5f, leftBottomCoordinate.y + 0.5f, 4);
//		Debug.Log("left down corner" + Camera.main.ViewportToWorldPoint(new Vector3(0,0,Camera.main.nearClipPlane)));
	}

	// Update is called once per frame
	void Update ()
	{
		// der allererste Klick oder Tastendruck startet das Spiel
		if (startTextIsShowing) {
			if (Input.anyKeyDown) {
				startScreen.SetActive (false);
				startTextIsShowing = false;
			} else
				return;
		}
		
		if (isGameOver)
			return;
	
		if (duckContainer.transform.childCount == 0)  // sammelt man alle instantiierten Objekte in einem Containerobjekt, ist das eine nette Art zu testen, wie viele gerade da sind
			gameOver (true);
	
		// Um die y-Achse drehen
		transform.Rotate (0, Input.GetAxis ("Mouse X") * rotateSpeed, 0);

		// Vorwaertsrichtung ermitteln		
		CharacterController controller = GetComponent<CharacterController> ();
		Vector3 forward = transform.TransformDirection (Vector3.forward);
	
		// seitlich wandern (sidestep)
		float strafeSpeed = speed * Input.GetAxis ("Horizontal");
		controller.SimpleMove (Vector3.Cross (Vector3.up, forward) * strafeSpeed);
 
		// Vor- und zurueck bewegen
		float forwardSpeed = speed * Input.GetAxis ("Vertical");
		controller.SimpleMove (forward * forwardSpeed);
		
		// Ball werfen
// dies ist ein Compiler-Statement, der Block darin wird nur eingebunden, wenn die Mac OSX Plattform oder der Webplayer in Unity ausgewaehlt ist
// in iOS wuerde dieses Statement bei jeder Bewegung (= Touch) einen Wurf ausloesen, das soll dort aber lieber mit einem Button in OnGUI gehen
#if (UNITY_STANDALONE_OSX || UNITY_WEBPLAYER)
		if (Input.GetKeyDown ("space") || Input.GetKeyDown ("space") || Input.GetMouseButtonDown (0))
			throwBall ();
#endif

	}
	
	// Spielstand einblenden
	void OnGUI ()
	{
		GUI.Label (new Rect (5, 0, 150, 100), "Enten: " + duckContainer.transform.childCount, customLabel);
		GUI.Label (new Rect (5, 50, 150, 100), "Baelle: " + throwsAvailable, customLabel);
// dies ist ein Compiler-Statement, der Block darin wird nur eingebunden, wenn die iPhone/Android Plattform in Unity ausgewaehlt ist
#if (UNITY_IPHONE || UNITY_ANDROID)
		if (GUI.RepeatButton (new Rect (5, Screen.height - 100, 80, 80), "Wurf"))
			throwBall ();
#endif
	}

	// Ball erzeugen und in Blickrichtung werfen
	private void throwBall ()
	{
		if (throwsAvailable == 0)
			return;
	
		Vector3 colorBallPosition = transform.position + new Vector3 (0, 0.5f, 0); // kleines Stueck nach vorne
		GameObject newcolorBall = (GameObject)Instantiate (colorBallPrefab, colorBallPosition, Quaternion.identity);
		newcolorBall.rigidbody.velocity = this.GetComponent<CharacterController> ().velocity; // auf Eigengeschwindigkeit bringen
		newcolorBall.name = "ColorBall";
		newcolorBall.renderer.material.color = colorTable [Random.Range (0, 3)];  // dem Ball zufaellig einen der drei Farbwerte zuweisen
		newcolorBall.GetComponent<ColorBallClass> ().playerClass = this;  // die 'playerClass' - Variable besetzen
		Vector3 targetPosition = transform.forward * 1000;
		newcolorBall.rigidbody.AddRelativeForce (new Vector3 (targetPosition.x, 200, targetPosition.z));  // Ball anschubsen
		throwsAvailable--;
	}
	
	public void gameOver (bool didWin)
	{
		isGameOver = true;
		if (didWin) {
			Debug.Log ("playing final sound");  // so gibt man eine Statusmeldung in der Unity Console aus
			audio.Play ();  // so spielt man den Soundeffekt ab, der am Spieleobjekt haengt. Z.B. von http://www.wavsource.com/sfx/sfx.htm
		}
		StartCoroutine (reloadLevel ());  // die Coroutine und das damit verbundene Warten gibt der Engine Zeit, den Sound zu spielen
	}
	
	private IEnumerator reloadLevel ()
	{
		yield return new WaitForSeconds(3);  // 3 Sekunden warten, dann weiter mit dem naechsten Befehl
		Application.LoadLevel (0);  // das ist ein sehr praktischer Befehl, um eine Szene komplett neu zu starten

	}
}
