//
//  DKAppDelegate.m
//  DemoKit
//
//  Created by Kai Brüning on 24.8.13.
//  Copyright (c) 2013 Hippocampus Software GmbH. All rights reserved.
//

#import "DKAppDelegate.h"
#import "DKMainWindowController.h"

NSString* productVariant;

@implementation DKAppDelegate

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
    // Die gewünschte Produktvariante wird aus der Info.plist der App gelesen und in einer globalen Variablen gemerkt.
    // NSBundle.mainBundle gibt immer das Bundle der laufenden Applikation zurück, auch wenn es - wie hier - aus einem
    // Framework aufgerufen wird.
    productVariant = [NSBundle.mainBundle objectForInfoDictionaryKey:@"de.hippocampus-software.variant"];
    
    // Anmerkung: In Produktionscode empfiehlt es sich, die Info.plist per Codesignatur gegen Manipulationen zu schützen
    // - sonst ist es ein bisschen zu einfach, die Light-Version zu "vervollständigen". Das geht über den Umfang dieses
    // Beispiels jedoch hinaus.
    
    [self openMainWindow];
}

- (void) openMainWindow
{
    DKMainWindowController* mainWindowController = self.mainWindowController;
    [mainWindowController showWindow:nil];
}

@synthesize mainWindowController = _mainWindowController;   // kein Auto-Synthesize da Accessor überschrieben ist

- (DKMainWindowController*) mainWindowController
{
    if (!_mainWindowController)
        _mainWindowController = [[DKMainWindowController alloc] init];
    return _mainWindowController;
}

@end
