//
//  Person.m
//  SwiftTest
//
//  Created by Kai Brüning on 25.7.14.
//  Copyright (c) 2014 Hippocampus Software GmbH. All rights reserved.
//

#import "Person.h"

@implementation Person
- (instancetype) initWithName:(NSString*)name {
    if ((self = [super init]) != nil)
        _name = name;	// = [name copy] wäre richtig
    return self;
}
@end

void testObjCPerson() {
    // Erzeuge einen veränderbaren String, der zum Initialisieren mehrerer Personen-Instanzen verwendet wird.
    NSMutableString* newName = [NSMutableString stringWithString:@"Karl"];
    
    // Erzeuge erste Person-Instanz mit 'newName'.
    Person* person1 = [[Person alloc] initWithName:newName];
    NSLog (@"person1: %@", person1.name);
    
    // 'newName' wird geändert, nachdem es zum Initialisieren von person1 benutzt wurde.
    [newName appendString:@"-Heinz"];
    // Erzeuge zweite Person-Instanz mit dem geänderten 'newName'.
    Person* person2 = [[Person alloc] initWithName:newName];
    
    // Beide Peronen heißen jetzt Karl-Heinz.
    NSLog (@"person1: %@", person1.name);
    NSLog (@"person2: %@", person2.name);
}
