//
//  Person.swift
//  SwiftTest
//
//  Created by Kai Brüning on 14.7.14.
//  Copyright (c) 2014 Hippocampus Software GmbH. All rights reserved.
//

import Foundation

class Person {
    init (name:String) {
        self.name = name
        // Füge die neue Instanz zu der Nachschlagetabelle nach Namen hinzu. Da bisher kein Geburtstag gesetzt ist, wird in der Tabelle nach Namen und Geburtstag kein Eintrag gemacht.
        PersonManager.sharedInstance.addPerson (self)
    }
    
    // Die Property-Beobachter für beide Properties entfernen die Instanz vor der Änderung aus den Nachschlagetabellen und fügen sie nach der Änderung wieder hinzu.

    var name: String {
        willSet {
            PersonManager.sharedInstance.removePerson (self)
        }
        didSet {
            PersonManager.sharedInstance.addPerson (self)
        }
    }

    var birthday: NSDate? {
        willSet {
            PersonManager.sharedInstance.removePerson (self)
        }
        didSet {
            PersonManager.sharedInstance.addPerson (self)
        }
    }
}
