//
//  Result.swift
//  SwiftTest
//
//  Created by Kai Brüning on 23/07/14.
//  Copyright (c) 2014 Hippocampus Software GmbH. All rights reserved.
//

import Foundation

// ACHTUNG: In der Beta 6 kann der Compiler diesen Code nicht übersetzen und meldet "unimplemented IR generation feature non-fixed multi-payload enum layout". Diese Datei ist daher nicht Teil des Targets.

enum Result<T> : NilLiteralConvertible {
    case Success(T)
    case Failure(NSError?)
    
    init(_ value: T) {
        self = .Success (value)
    }
    
    init(_ error: NSError? = nil) {
        self = .Failure (error)
    }

    // Implementation des Protokolls "NilLiteralConvertible": nil representiert ein Fehlerresultat ohne Fehlerobjekt.
    static func convertFromNilLiteral() -> Result<T> {
        return Result<T>()
    }
    
    // Berechnete Property, die zurückgibt, ob der Aufruf erfolgreich war.
    var isSuccess: Bool {
        switch (self) {
        case .Success:
            return true
        case .Failure:
            return false
        }
    }
    
    // Zugriff auf den Wert. Darf nur verwendet werden, wenn vorher getestet wird, ob der Aufruf erfolgreich war.
    var value : T {
        // Eine switch-Anweisung ist der einzige Weg, auf die zugeordneten Werte einer enum zuzugreifen.
        switch (self) {
        case .Success (let value):
            return value
        case .Failure:
            // fatalError ist mit @noreturn annotiert, deshalb lässt der Compiler zu, dass kein Wert zurückgegeben wird.
            fatalError("Illegal access to the value of a failure result")
        }
    }

    // Zugriff auf den Fehler. Darf nur verwendet werden, wenn vorher getestet wird, ob der Aufruf fehlgeschlagen ist.
    var error : NSError? {
        switch (self) {
        case .Success:
            fatalError("Illegal access to the error of a success result")
        case .Failure (let error):
            return error
        }
    }
}

