//
//  main.swift
//  SwiftTest
//
//  Created by Kai Brüning on 14.7.14.
//  Copyright (c) 2014 Hippocampus Software GmbH. All rights reserved.
//

import Foundation
import Cocoa

func runTestFunction(name:String, f:()->()) {
    println("\(name):")
    f()
    println()
}

runTestFunction("Exercise Optionals") { exerciseOptionals() }

runTestFunction("Exercise Functions on Integer") { exerciseFunctionsOnInteger() }

runTestFunction("Exercise personWithName") { exercisePersonWithName() }

runTestFunction("Exercise personWithNameAndBirthDay") { exercisePersonWithNameAndBirthDay() }

// Diese Funktion demonstriert den Effekt eines vergessenen -copy für einen veränderbaren String
runTestFunction("Test Obj-C Person") { testObjCPerson() }

// Testfunktion für Result<T>. Kann verwendet werden, sobald der Compiler Result<T> beherrscht.
//runTestFunction("Test Result<T>") { testResult() }


