// 2020 Richard Kurz, no rights reserved.

#include <Arduino.h>

//#define USE_MAC_LAYOUT 1
#include "LayoutDE.h"

#if defined (__AVR_ATmega32U4__)

#define BUTTON_PIN  4

#include "USB_ATmega32U4.h"

#elif defined (__AVR_ATtiny85__)

#define BUTTON_PIN  0

#include "USB_ATtiny85.h"

#elif defined (ESP32)

#define BUTTON_PIN  0

#include "BLE_ESP32.h"

#else
#error "Unbekannte CPU"
#endif


void setup()
{
  pinMode(BUTTON_PIN, INPUT_PULLUP);

#ifndef __AVR_ATtiny85__

  Serial.begin(115200);

#if defined (__AVR_ATmega32U4__)
  // Bei Bedarf kann hier auf den seriellen Monitor gewartet werden.
  // while (!Serial) {}
#endif

  Serial.println("Hello World");

#endif

  kbdOut.begin();
}


void loop()
{
  static unsigned long lastTime = millis();
  unsigned long now = millis();

  if (!digitalRead(BUTTON_PIN))
  {
    if (abs(now - lastTime) > 1000)
    {
      lastTime = now;

      kbdOut.print("(- xyz äöü ÄÖÜ []|{} -)");
      kbdOut.sendMediaKeyStroke(kHID_MediaVolumeMute);
    }
  }
}
