// 2020 Richard Kurz, no rights reserved.

#pragma once

#include <avr/delay.h>
#include <UsbDevice.h>


static uint8_t usbLedState = 0;

struct USB_ATtiny85
{
  uint8_t report_buffer[8] = {0};

  void begin()
  {
    cli();

    usbDeviceDisconnect();
    _delay_ms(250);

    usbDeviceConnect();
    usbInit();

    sei();

    usbSetInterrupt(report_buffer, sizeof(report_buffer));
  }
  

  void delay(unsigned long ms)
  {
    if (!ms) usbPoll();
    else
    {
      unsigned long last = millis();
      while (ms > 0)
      {
        usbPoll();
        unsigned long now = millis();
        ms -= now - last;
        last = now;
      }
    }
  }


  void sendReport(uint8_t* report, uint8_t size)
  {
    while (!usbInterruptIsReady())
    {
      usbPoll();
      _delay_ms(5);
    }
    usbSetInterrupt(report, size);
  }
  

  void sendKeyPress(uint8_t keyPress, uint8_t modifiers)
  {
    report_buffer[0] = kReportIdKeyboard;
    report_buffer[1] = modifiers;
    report_buffer[2] = 0;
    report_buffer[3] = keyPress;
    report_buffer[4] = report_buffer[5] = report_buffer[6] = report_buffer[7] = 0;

    sendReport(report_buffer, 8);
  }

  
  void sendMediaKeyPress(uint16_t keyPress)
  {
    report_buffer[0] = kReportIdMediaKeys;
    report_buffer[1] = keyPress & 0xff;
    report_buffer[2] = keyPress << 8;

    sendReport(report_buffer, 3);
  }
};


extern "C" uchar usbFunctionSetup(uchar data[8])
{
  usbRequest_t* rq = (usbRequest_t*)data;

  if ((rq->bmRequestType & USBRQ_TYPE_MASK) == USBRQ_TYPE_CLASS)
    if (rq->bRequest == USBRQ_HID_SET_REPORT)
      return USB_NO_MSG; 

  return 0;
}


usbMsgLen_t usbFunctionWrite(uint8_t * data, uchar len)
{
  usbLedState = data[1];
  return 1;
}


LayoutMacDE<USB_ATtiny85> keyboard;
