// 2020 Richard Kurz, no rights reserved.

#pragma once


struct Analog4x4
{
  const byte outPin = A0;

  void begin()
  {
  }

  byte getKey()
  {
    byte k = 0;
    word r = analogRead(outPin);
    
#if defined (ESP32)
    if      (r > 4000) k = 1;
    else if (r > 3700) k = 2;
    else if (r > 3300) k = 3;
    else if (r > 2800) k = 4;
    else if (r > 2550) k = 5;
    else if (r > 2400) k = 6;
    else if (r > 2250) k = 7;
    else if (r > 2100) k = 8;
    else if (r > 1880) k = 9;
    else if (r > 1790) k = 10;
    else if (r > 1700) k = 11;
    else if (r > 1590) k = 12;
    else if (r > 1400) k = 13;
    else if (r > 1050) k = 14;
    else if (r > 880)  k = 15;
    else if (r > 600)  k = 16;
#else
    if      (r > 976) k = 1;
    else if (r > 890) k = 2;
    else if (r > 820) k = 3;
    else if (r > 735) k = 4;
    else if (r > 660) k = 5;
    else if (r > 620) k = 6;
    else if (r > 585) k = 7;
    else if (r > 540) k = 8;
    else if (r > 499) k = 9;
    else if (r > 476) k = 10;
    else if (r > 455) k = 11;
    else if (r > 427) k = 12;
    else if (r > 370) k = 13;
    else if (r > 303) k = 14;
    else if (r > 257) k = 15;
    else if (r > 200) k = 16;
#endif

    return k;
  }

};

Analog4x4 kbdIn;
