// 2020 Richard Kurz, no rights reserved.

#pragma once

#include <HID.h>


struct USB_ATmega32U4
{
  uint8_t report_buffer[8] = {0};

  
  USB_ATmega32U4()
  {
    static HIDSubDescriptor node(hidReportDescriptor, sizeof(hidReportDescriptor));
    HID().AppendDescriptor(&node);
  }

  
  void begin()
  {
  }

  
  void delay(unsigned long ms)
  {
    ::delay(ms);
  }

  
  void sendKeyPress(uint8_t keyPress, uint8_t modifiers)
  {
    report_buffer[0] = modifiers;
    report_buffer[1] = 0;
    report_buffer[2] = keyPress;
    report_buffer[3] = report_buffer[4] = report_buffer[5] = report_buffer[6] = report_buffer[7] = 0;

    HID().SendReport(kReportIdKeyboard, report_buffer, 8);
  }


  void sendMediaKeyPress(uint16_t keyPress)
  {
    report_buffer[0] = keyPress & 0xff;
    report_buffer[1] = keyPress << 8;

    HID().SendReport(kReportIdMediaKeys, report_buffer, 2);
  }
};

LayoutMacDE<USB_ATmega32U4> kbdOut;
