// 2020 Richard Kurz, no rights reserved.

#pragma once


struct TTP229
{
#if defined (__AVR_ATmega32U4__)

  static const byte sclPin = 3, sdoPin = 2, btnCnt = 16;

#elif defined (__AVR_ATtiny85__)

  static const byte sclPin = 1, sdoPin = 0, btnCnt = 16;

#elif defined (ESP32)

  static const byte sclPin = 19, sdoPin = 18, btnCnt = 16;

#endif

  void begin()
  {
    pinMode(sclPin, OUTPUT);
    pinMode(sdoPin, INPUT);
    digitalWrite(sclPin, HIGH);
  }

  byte getKey()
  {
    word keys = 0;
    byte k = 0;

    digitalWrite(sclPin, HIGH);
    for (byte i = 0; i < btnCnt; ++i )
    {
      delayMicroseconds(2);
      digitalWrite(sclPin, LOW);
      delayMicroseconds(2);
      digitalWrite(sclPin, HIGH);

      bool b = !digitalRead(sdoPin);
      if (b) k = i + 1;
      keys |= (b << i);
    }

    return k;
  }
};

TTP229 kbdIn;
