#tag Class
Protected Class JSONListbox
Inherits Listbox
	#tag Event
		Function CellBackgroundPaint(g As Graphics, row As Integer, column As Integer) As Boolean
		  
		  Var bgcolor As Color // Platzhalter für die Hintergrundfarbe
		  If row < Me.RowCount Then // Nichts tun, wenn keine gültige Zeile mehr
		    If Me.ExpandableRowAt(row) Then // Aufklappzeile?
		      bgcolor = If (Color.IsDarkMode, Color.DarkGray, Color.LightGray) // Grau hinterlegen
		    Else // Wert-Datenpaar
		      If row Mod 2 = 1 Then // abwechselnd füllen
		        bgcolor = Color.Clear // durchsichtig = Tabellenhintergrund
		      Else // oder je nach DarkMode leicht gefärbt
		        bgcolor = _
		        If (Color.IsDarkMode,  Color.HSV( Color.FillColor.Hue, Max(Color.FillColor.Saturation -0.9, 0.015), 0.1), _
		        Color.HSV(Color.FillColor.hue, Min(Color.FillColor.Saturation -0.3, 0.85), 0.8))
		      End If
		    End If
		    g.DrawingColor = bgcolor // Farbe setzen
		    g.FillRectangle 0,0,g.Width, g.Height // und den Hintergrund der Zelle damit füllen
		  End If
		  #Pragma Unused column
		End Function
	#tag EndEvent

	#tag Event
		Sub CollapseRow(row As Integer)
		  Var tag As Variant = Me.RowTagAt(row)// Rowtag der Aufklappzeile lesen
		  If tag <>Nil Then // Existiert?
		    Var tagarray() As Variant = Tag // Als StringArray nutzbar machen
		    row = row +1
		    For q As Integer = 0 To tagarray.LastRowIndex
		      Var stringarray() As String = tagarray(q)
		      If stringarray.Count > 1 Then // Teil einer Namens/Wertepaarliste?
		        Me.RemoveRowAt (row) // Alle zuzuklappenden Zeilen entfernen
		      Else
		        row = row +1
		      End If
		    Next
		  End If
		End Sub
	#tag EndEvent

	#tag Event
		Sub ExpandRow(row As Integer)
		  Var tag As Variant = Me.RowTagAt(row)// Rowtag der Aufklappzeile lesen
		  If tag <>Nil Then // Existiert?
		    row = row + 1 // Inkrementierung wegen einfacherer Addition in Zeilen 8/12
		    Var tagarray() As Variant = Tag // Als TagArray nutzbar machen
		    For q As Integer = 0 To tagarray.LastRowIndex // Alle Reihen
		      Var stringarray() As String = tagarray(q) // Deren Einträge
		      If stringarray.Count = 1 Then // Nur ein Wert – Teil eines Arrays
		        Me.AddRowAt(row+q, stringarray(0), 1) // einfügen
		      Else
		        Me.AddRowAt(row+q, stringarray(0), 0) // Den Namen einfügen
		        For p As Integer = 1 To stringarray.LastRowIndex
		          Me.CellValueAt(row+q,p) = stringarray(p) // Wert(e) nachtragen
		        Next
		      End If
		    Next
		  End If
		End Sub
	#tag EndEvent


	#tag Method, Flags = &h21, Description = 46C3BC67742065696E20537472696E672D4172726179206D6974205A656C6C656E696E68616C74656E20696E2064656E20526F777461672065696E6572204175666B6C6170707A65696C652065696E2E
		Private Sub AddRowValue(Index as Integer, ParamArray Values as String)
		  Var tag As Variant = Me.RowTagAt(Index) // Rowtag der Aufklappzeile lesen
		  If tag = Nil Then // Existiert er noch nicht?
		    Var tagarray() As Variant
		    tagarray.AddRow values // neuen Wert anhängen
		    Tag = tagarray // Jetzt ja, als Variant-Array
		    Me.RowTagAt(Index) = tag // Rowtag in Aufklappzeile schreiben
		  Else //existierte schon
		    Var tagarray() As Variant = Tag // Als Variant-Array nutzbar machen
		    tagarray.AddRow values // neuen Wert anhängen
		  End If
		  
		End Sub
	#tag EndMethod

	#tag Method, Flags = &h0, Description = 46C3BC67742065696E2042696C6420756E7465722064656D205363686CC3BC7373656C205461672064656D205069637475726543616368652068696E7A752E
		Sub AddToPictureCache(Tag as String, Pic as Picture)
		  PictureCache.Value(Tag) = pic
		End Sub
	#tag EndMethod

	#tag Method, Flags = &h0, Description = 4C6569666572742054727565207A7572C3BC636B2C2077656E6E20756E7465722064656D204E616D656E2065696E2042696C6420696D2050696374757265436163686520766F7268616E64656E206973742E
		Function HasPicture(Name as String) As Boolean
		  return PictureCache.HasKey(name)
		End Function
	#tag EndMethod

	#tag Method, Flags = &h0, Description = 4C696566657274206461732042696C642C2064617320756E7465722064656D204E616D656E20696D2050696374757265436163686520616267656C656774206973742E
		Function Picture(Name as String) As Picture
		  return PictureCache.value(name)
		End Function
	#tag EndMethod

	#tag Method, Flags = &h21, Description = 4261757420646965204C697374626F78206175662E2057697264206175746F6D617469736368206265696D205A7577656973656E2065696E6573204A534F4E73207A7520446174612067657461727465742E
		Private Sub RebuildView(JS as JSONItem, Level as integer)
		  If js <> Nil Then // Gibt es einen gültigen JSON?
		    Var StringValue As String // Puffer für den FormattedString
		    Var Pic As Picture
		    Var index As Integer = Me.LastRowIndex // als aktuelle Einfügeposition zwischenspeichern.
		    If js.IsArray Then // Ist er ein Array?
		      Var count As Integer = js.Count // Wie viele Elemente?
		      Count = count -1 // Wegen Schleifenbeginn bei 0 1 subtahieren
		      For q As Integer = 0 To count // Alle Array-Elemente
		        Var value As Variant= js.ValueAt(q)
		        If value IsA JSONItem Then // JSONItem = Neuer Aufklappeintrag!
		          If count > 0 Or level >-1 Then // Ersten Eintrag (Root) ausklammern
		            Me.AddExpandableRow name
		          End If
		          RebuildView(js.ChildAt(q), Level +1) // Kinder des JSONs bearbeiten
		        Else
		          StringValue = value.formattedstringvalue(locale.current)
		          Me.AddRowValue(Index, stringvalue) // Wert zu Aufklappmenü hinzufügen
		          Pic = StringValue.toPicture
		          If pic <> Nil Then PictureCache.value(name) = Pic
		        End If
		      Next
		    Else // kein Array 
		      Var names() As String = JS.Names // Alle Kinder
		      For Each name As String In names
		        If JS.Value(name) IsA JSONItem Then // Neuer "Zweig" des JSON-Baums?
		          Me.AddExpandableRow name // von hier ab bearbeiten
		          RebuildView(JS.Child(name), Level +1)
		        Else // Nein –Ist ein Werte-Eintrag
		          If level =0 Then
		            Me.AddRow  name, JS.Value(name).formattedStringValue(locale.current) // Namen und Wert in Liste eintragen
		          Else 
		            StringValue = js.value(name).formattedstringvalue(locale.current)
		            Me.AddRowValue(Index, name, stringvalue) // Wert zu Aufklappmenü hinzufügen
		            Pic = StringValue.toPicture
		            If pic <> Nil Then PictureCache.value(name) = Pic
		          End If
		        End If
		      Next
		    End If
		  End If
		  
		End Sub
	#tag EndMethod


	#tag Hook, Flags = &h0, Description = 4665756572742C2077656E6E2065696E206E65756572204A534F4E207A75676577696573656E2077757264652E
		Event DataChanged()
	#tag EndHook


	#tag ComputedProperty, Flags = &h0, Description = 446572206461727A757374656C6C656E6465204A534F4E2E
		#tag Getter
			Get
			  Return mData
			End Get
		#tag EndGetter
		#tag Setter
			Set
			  mData = value
			  Me.RemoveAllRows
			  PictureCache.RemoveAll
			  RebuildView(mdata, -1)
			  RaiseEvent DataChanged
			End Set
		#tag EndSetter
		Data As JSONItem
	#tag EndComputedProperty

	#tag Property, Flags = &h21
		Private mData As JSONItem
	#tag EndProperty

	#tag Property, Flags = &h21
		Private mPictureCache As Dictionary
	#tag EndProperty

	#tag ComputedProperty, Flags = &h21
		#tag Getter
			Get
			  // Lazy Initialisierung für das Dictionary
			  If mPictureCache = Nil Then
			    mPictureCache = New Dictionary
			  End If
			  Return mPictureCache
			End Get
		#tag EndGetter
		Private PictureCache As Dictionary
	#tag EndComputedProperty


	#tag ViewBehavior
		#tag ViewProperty
			Name="Name"
			Visible=true
			Group="ID"
			InitialValue=""
			Type="String"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Index"
			Visible=true
			Group="ID"
			InitialValue=""
			Type="Integer"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Super"
			Visible=true
			Group="ID"
			InitialValue=""
			Type="String"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Left"
			Visible=true
			Group="Position"
			InitialValue="0"
			Type="Integer"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Top"
			Visible=true
			Group="Position"
			InitialValue="0"
			Type="Integer"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Width"
			Visible=true
			Group="Position"
			InitialValue="100"
			Type="Integer"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Height"
			Visible=true
			Group="Position"
			InitialValue="100"
			Type="Integer"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="LockLeft"
			Visible=true
			Group="Position"
			InitialValue="True"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="LockTop"
			Visible=true
			Group="Position"
			InitialValue="True"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="LockRight"
			Visible=true
			Group="Position"
			InitialValue="False"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="LockBottom"
			Visible=true
			Group="Position"
			InitialValue="False"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="TabIndex"
			Visible=true
			Group="Position"
			InitialValue="0"
			Type="Integer"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="TabPanelIndex"
			Visible=false
			Group="Position"
			InitialValue="0"
			Type="Integer"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="TabStop"
			Visible=true
			Group="Position"
			InitialValue="True"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="_ScrollOffset"
			Visible=false
			Group="Appearance"
			InitialValue="0"
			Type="Integer"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="_ScrollWidth"
			Visible=false
			Group="Appearance"
			InitialValue="-1"
			Type="Integer"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="AllowAutoDeactivate"
			Visible=true
			Group="Appearance"
			InitialValue="True"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="HasBorder"
			Visible=true
			Group="Appearance"
			InitialValue="True"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="ColumnCount"
			Visible=true
			Group="Appearance"
			InitialValue="1"
			Type="Integer"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="ColumnWidths"
			Visible=true
			Group="Appearance"
			InitialValue=""
			Type="String"
			EditorType="MultiLineEditor"
		#tag EndViewProperty
		#tag ViewProperty
			Name="DefaultRowHeight"
			Visible=true
			Group="Appearance"
			InitialValue="-1"
			Type="Integer"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Enabled"
			Visible=true
			Group="Appearance"
			InitialValue="True"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="GridLinesHorizontalStyle"
			Visible=true
			Group="Appearance"
			InitialValue="0"
			Type="Borders"
			EditorType="Enum"
			#tag EnumValues
				"0 - Default"
				"1 - None"
				"2 - ThinDotted"
				"3 - ThinSolid"
				"4 - ThickSolid"
				"5 - DoubleThinSolid"
			#tag EndEnumValues
		#tag EndViewProperty
		#tag ViewProperty
			Name="GridLinesVerticalStyle"
			Visible=true
			Group="Appearance"
			InitialValue="0"
			Type="Borders"
			EditorType="Enum"
			#tag EnumValues
				"0 - Default"
				"1 - None"
				"2 - ThinDotted"
				"3 - ThinSolid"
				"4 - ThickSolid"
				"5 - DoubleThinSolid"
			#tag EndEnumValues
		#tag EndViewProperty
		#tag ViewProperty
			Name="HasHeader"
			Visible=true
			Group="Appearance"
			InitialValue="False"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="HeadingIndex"
			Visible=true
			Group="Appearance"
			InitialValue="-1"
			Type="Integer"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Tooltip"
			Visible=true
			Group="Appearance"
			InitialValue=""
			Type="String"
			EditorType="MultiLineEditor"
		#tag EndViewProperty
		#tag ViewProperty
			Name="InitialValue"
			Visible=true
			Group="Appearance"
			InitialValue=""
			Type="String"
			EditorType="MultiLineEditor"
		#tag EndViewProperty
		#tag ViewProperty
			Name="HasHorizontalScrollbar"
			Visible=true
			Group="Appearance"
			InitialValue="False"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="HasVerticalScrollbar"
			Visible=true
			Group="Appearance"
			InitialValue="True"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="DropIndicatorVisible"
			Visible=true
			Group="Appearance"
			InitialValue="False"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Transparent"
			Visible=true
			Group="Appearance"
			InitialValue="False"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="AllowFocusRing"
			Visible=true
			Group="Appearance"
			InitialValue="True"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Visible"
			Visible=true
			Group="Appearance"
			InitialValue="True"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Bold"
			Visible=true
			Group="Font"
			InitialValue="False"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="Italic"
			Visible=true
			Group="Font"
			InitialValue="False"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="FontName"
			Visible=true
			Group="Font"
			InitialValue="System"
			Type="String"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="FontSize"
			Visible=true
			Group="Font"
			InitialValue="0"
			Type="Single"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="FontUnit"
			Visible=true
			Group="Font"
			InitialValue="0"
			Type="FontUnits"
			EditorType="Enum"
			#tag EnumValues
				"0 - Default"
				"1 - Pixel"
				"2 - Point"
				"3 - Inch"
				"4 - Millimeter"
			#tag EndEnumValues
		#tag EndViewProperty
		#tag ViewProperty
			Name="Underline"
			Visible=true
			Group="Font"
			InitialValue="False"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="AllowAutoHideScrollbars"
			Visible=true
			Group="Behavior"
			InitialValue="True"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="AllowResizableColumns"
			Visible=true
			Group="Behavior"
			InitialValue="False"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="AllowRowDragging"
			Visible=true
			Group="Behavior"
			InitialValue="False"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="AllowRowReordering"
			Visible=true
			Group="Behavior"
			InitialValue="False"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="AllowExpandableRows"
			Visible=true
			Group="Behavior"
			InitialValue="False"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="RequiresSelection"
			Visible=true
			Group="Behavior"
			InitialValue="False"
			Type="Boolean"
			EditorType=""
		#tag EndViewProperty
		#tag ViewProperty
			Name="RowSelectionType"
			Visible=true
			Group="Behavior"
			InitialValue="0"
			Type="RowSelectionTypes"
			EditorType="Enum"
			#tag EnumValues
				"0 - Single"
				"1 - Multiple"
			#tag EndEnumValues
		#tag EndViewProperty
		#tag ViewProperty
			Name="DataSource"
			Visible=true
			Group="Database Binding"
			InitialValue=""
			Type="String"
			EditorType="DataSource"
		#tag EndViewProperty
		#tag ViewProperty
			Name="DataField"
			Visible=true
			Group="Database Binding"
			InitialValue=""
			Type="String"
			EditorType="DataField"
		#tag EndViewProperty
		#tag ViewProperty
			Name="InitialParent"
			Visible=false
			Group=""
			InitialValue=""
			Type="String"
			EditorType=""
		#tag EndViewProperty
	#tag EndViewBehavior
End Class
#tag EndClass
