#tag Module
Protected Module VariantExtension
	#tag Method, Flags = &h0, Description = 4C6965666572742065696E656E206F7264656E746C69636820666F726D617469657274656E20546578742066C3BC722056617269616E747320766F6D2054797020446F75626C652C2053696E676C652C20496E7465676572206F64657220446174756D207A7572C3BC636B2E
		Function FormattedStringValue(extends v as variant, loc as Locale) As String
		  If v.IsNull Then
		    Return ""
		  Else
		    Select Case v.Type
		    Case  Variant.TypeDouble, Variant.TypeSingle
		      Return v.DoubleValue.ToString(loc)
		    Case  Variant.TypeInteger
		      Return v.IntegerValue.ToString(loc)
		    Else
		      Var s As String = v.StringValue
		      // Ein Datum wird auch als String abgelegt, aber in keinem Xojo-kompatiblen Format.
		      // Der String muss daher vor Rückgabe analyisiert werden.
		      Var datestring As String = s.Replace(":", "-").Replace(":", "-") // Duplikat zur Überarbeitung,
		      // aber ggf. die ersten beiden Doppelpunkte durch Date.ToString-kompatibles Format ersetzt
		      Var pos As Integer = datestring.IndexOf("+") // Gibt es einen Zeit-Offset?
		      If pos = -1 Then pos = datestring.IndexOf("-") // oder einen negativen?
		      Var tz As TimeZone // Benötigt für den Zeitoffset in Datmsstrings
		      #Pragma BreakOnExceptions False
		      // Pragma-Befehle sind Compilerkommandos.
		      // Ohne obiges würde das Programm im Debugger stoppen, falls gleich kein Datum erzeugt werden kann.
		      Try // Ganz wörtlich: Versuche …
		        If pos > -1 Then // ja – er muss entfernt werden, damit Datetime.fromstring funktioniert
		          Var dateoffset As String = datestring.Middle(pos) // Zwischenspeichern
		          datestring = datestring.Left(datestring.Length - dateoffset.Length) // und aus Datestring entfernen
		          If dateoffset.BeginsWith("+") Then dateoffset = dateoffset.Right(dateoffset.Length-1) // +-Zeichen etfernen
		          Var dateOffsetParts() As String = dateoffset.Split(":") // Am Doppelpunkt teilen
		          tz = New TimeZone(Integer.FromString(dateOffsetParts(0))*3600 + _
		          If (dateOffsetParts.Count > 1, Integer.FromString(dateOffsetParts(1))*60, 0))
		          // Stunden und Minuten berechnen:
		          // Dateoffset gibt Stunden:Minuten an, TimeZone erwartet Sekunden
		        End If
		        Var d As DateTime = DateTime.FromString(datestring, Nil, tz) // Datums-Objekt erzeugen
		        Return d.ToString(loc, DateTime.FormatStyles.Medium, DateTime.FormatStyles.Medium) // und String liefern
		      Catch // Fange einen Fehler auf, fahre in diesem Fall hier weiter:
		        Return s
		      End Try
		    End Select
		  End If
		   
		End Function
	#tag EndMethod


End Module
#tag EndModule
