#!/usr/bin/env osascript -l JavaScript

'use strict';

(() => {
  const quellOrdner = dokumentOrdnerFinden();
  const zielOrdner = `${quellOrdner}/Briefe`;
  ordnerErstellen(zielOrdner);
  const pagesName = 'Serienbrief-Geburtstag.pages';
  const numbersName = 'Adressen.numbers';
  const dokumentOrdner = dokumentOrdnerFinden();
  const pagesDokument = pagesDokumentÖffnen(`${dokumentOrdner}/${pagesName}`);
  const numbersTabelle = numbersTabelleLesen(`${dokumentOrdner}/${numbersName}`);
  const datenAnzahl = numbersTabelle.rows.length;
  const spaltenTitel = numbersTabelle.rows[0].cells.value();
  for (let i = 1; i < datenAnzahl; i++) {
    const zeile = numbersTabelle.rows[i];
    const datenZeile = datenZeileBauen(spaltenTitel, zeile);
    const briefName = `${dokumentOrdner}/${datenZeile.Vorname}-${datenZeile.Nachname}.pages`;
    const briefDokument = neuerBrief(pagesDokument, briefName);
    serienbriefFüllen(briefDokument, datenZeile);
    briefSpeichern(briefDokument, zielOrdner);
    aufräumen(briefDokument);
  }
})();

function ordnerErstellen(ordner) {
  const shellCmd = `mkdir "${ordner}"`;
  try {
    shellCommand(shellCmd);
  } catch(error) {
    if (error.errorNumber === 1) return;
    throw(error);
  }
}

function pagesDokumentÖffnen(dateiName) {
  const pagesApp = Application('Pages');
  return pagesApp.open(Path(dateiName));
}

function numbersTabelleLesen(dateiName) {
  const numbersApp = Application('Numbers');
  return numbersApp.open(Path(dateiName)).sheets[0].tables[0];
}

function dokumentOrdnerFinden() {
  const SE = Application('System Events');  
  return SE.documentsFolder.posixPath();
}

function neuerBrief(pagesDokument, neueDatei) {
  const pagesApp = Application('Pages');
  shellCommand(`touch "${neueDatei}" && chmod 600 "${neueDatei}"`);
  pagesApp.save(pagesDokument, {in: Path(neueDatei)});
  return pagesApp.open(neueDatei);
}

function datenZeileBauen(spaltenTitel, zeile){
  const datenZeile = {};
  spaltenTitel.forEach((titel, index) => {
    datenZeile[titel] = zeile.cells[index].value();
  });
  return datenZeile;
}

function serienbriefFüllen(pagesDokument, tabellenZeile) {
  const briefAnreden = { 'm': 'r', 
      'd' : '*', 
      'w' : ''};
  const platzhalterListe = pagesDokument.placeholderTexts;
  const platzhalterAnzahl = platzhalterListe.length;
  for (let i = 0; i < platzhalterAnzahl; i++) {
    const phName = platzhalterListe[0].tag();
    const ersatzText = phName === 'Anrede' ? 
      briefAnreden[tabellenZeile[phName]] : tabellenZeile[phName];
    platzhalterListe[0].set(ersatzText);
  }
}

function briefSpeichern(dokument, ordner) {
  const pagesApp = Application('Pages');
  const name = dokument.name();
  const pdfName = `${ordner}/${name}.pdf`;
  pagesApp.export(dokument, {as: 'PDF', to: Path(pdfName)});
}

function aufräumen(dokument) {
  const pagesApp = Application('Pages');
  const path = dokument.file();
  pagesApp.close(dokument, {saving: 'no'});
  shellCommand(`rm "${path}"`);
}

function shellCommand(cmd) {
  const currentApp = Application.currentApplication();
  currentApp.includeStandardAdditions = true;
  currentApp.doShellScript(cmd);
}
