//
//  Copyright © 2021 app|tects All rights reserved.
//

import SceneKit
import simd

public extension simd_float4x4 {
    var position: simd_float3 {
        simd_float3(self.columns.3.x, self.columns.3.y, self.columns.3.z)
    }

    var xAxis: simd_float3 {
        simd_float3(columns.0.x, columns.0.y, columns.0.z)
    }

    var yAxis: simd_float3 {
        simd_float3(columns.1.x, columns.1.y, columns.1.z)
    }

    var zAxis: simd_float3 {
        simd_float3(columns.2.x, columns.2.y, columns.2.z)
    }

    var eulerAngles: simd_float3 {
        simd_float3(x: asin(-self[2][1]),
                    y: atan2(self[2][0], self[2][2]),
                    z: atan2(self[0][1], self[1][1]))
    }

    init(simd: simd_float4x4) {
        self = simd
    }
}
