//
//  Copyright © 2021 app|tects All rights reserved.
//

import Foundation
import RealityKit

class BasketballSystem: System {
    private static let query = EntityQuery(where: .has(BasketballComponent.self))
    private static let dissolveDuration = TimeInterval(4)

    required init(scene: Scene) {}

    func update(context: SceneUpdateContext) {
        let currentTime = Date()

        context.scene.performQuery(Self.query).forEach { entity in
            if let basketballComponent = entity.components[BasketballComponent.self] as? BasketballComponent {
                if basketballComponent.timeToDie <= currentTime {
                    entity.removeFromParent()
                } else {
                    if currentTime >= basketballComponent.timeToDie - Self.dissolveDuration {
                        let progress = 1.0 - (Float(currentTime.distance(to: basketballComponent.timeToDie)) / Float(Self.dissolveDuration)).clamped(to: 0 ... 1)

                        if var modelComponent = entity.components[ModelComponent.self] as? ModelComponent {
                            modelComponent.materials = modelComponent.materials.map { material -> Material in
                                if var customMaterial = material as? CustomMaterial {
                                    customMaterial.custom.value[0] = progress
                                    return customMaterial
                                }
                                return material
                            }

                            entity.components[ModelComponent.self] = modelComponent
                        }
                    }
                }
            }
        }
    }
}
