//
//  Copyright © 2021 app|tects All rights reserved.
//

import ARKit
import SwiftUI

struct MainView: View {
    @EnvironmentObject var assetModel: AssetModel

    var body: some View {
        if isARKitSupportAvailable {
            if assetModel.allAssetsLoaded {
                NavigationView {
                    VStack {
                        Text("Heise AR Ball")
                            .font(.title)
                            .bold()
                        Spacer()
                        NavigationLink(destination: GameView.fullscreen) {
                            Text("Start")
                                .font(.title2)
                        }
                        Spacer()
                    }
                }
                .navigationViewStyle(StackNavigationViewStyle())
            } else {
                VStack {
                    Text("Loading Assets...")
                        .font(.title)
                        .bold()
                    ProgressView()
                }
                .padding()
            }
        } else {
            Text("This device does not support AR World-Tracking")
                .font(.title)
                .bold()
                .padding()
        }
    }

    private var isARKitSupportAvailable: Bool {
        ARWorldTrackingConfiguration.isSupported
    }
}

struct MainView_Previews: PreviewProvider {
    static var previews: some View {
        MainView()
    }
}
