//
//  Copyright © 2021 app|tects All rights reserved.
//

import RealityKit

public extension CollisionEvents.Began {
    var isCollisionBetweenBasketballAndTrashCan: Bool {
        (entityA.name == AssetModel.basketBallEntityName || entityB.name == AssetModel.basketBallEntityName) &&
            (entityA.name == AssetModel.triggerVolumeEntityName || entityB.name == AssetModel.triggerVolumeEntityName)
    }

    var basketBallEntity: Entity {
        entityA.name == AssetModel.basketBallEntityName ? entityA : entityB
    }
}
