//
//  Copyright © 2021 app|tects All rights reserved.
//

import CoreImage
import Metal
import MetalKit
import RealityKit

class PostProcess {
    private var ciContext: CIContext?
    private var targetImage: CIImage?

    init(device: MTLDevice) {
        ciContext = CIContext(mtlDevice: device)

        let loader = MTKTextureLoader(device: device)
        let emojiTexture = try? loader.newTexture(name: "emoji", scaleFactor: 1, bundle: .main)
        targetImage = CIImage(mtlTexture: emojiTexture!)

        let offsetX = -((targetImage!.extent.width - UIScreen.main.bounds.width * UIScreen.main.scale) / 2)
        let offsetY = -((targetImage!.extent.height - UIScreen.main.bounds.height * UIScreen.main.scale) / 2)

        targetImage = targetImage?.transformed(by: CGAffineTransform(translationX: offsetX, y: offsetY))
    }

    public func render(context: ARView.PostProcessContext, progress: Float) {
        let sourceColor = CIImage(mtlTexture: context.sourceColorTexture)

        let filter = CIFilter.barsSwipeTransition()
        filter.barOffset = 1
        filter.time = progress
        filter.width = 20
        filter.inputImage = sourceColor
        filter.angle = 3
        filter.targetImage = targetImage

        let destination = CIRenderDestination(mtlTexture: context.targetColorTexture, commandBuffer: context.commandBuffer)

        destination.isFlipped = false

        _ = try? ciContext?.startTask(toRender: filter.outputImage!, to: destination)
    }
}
