//
//  Copyright © 2021 app|tects All rights reserved.
//

#include <metal_stdlib>
#include <RealityKit/RealityKit.h>

using namespace metal;

[[visible]]
void spikeShader(realitykit::geometry_parameters params) {
    realitykit::geometry_modifier::uniforms uniforms = params.uniforms();
    float progress = uniforms.custom_parameter()[0];

    if (progress > 0) {
        realitykit::geometry_modifier::geometry geometry = params.geometry();

        float timeScaled = uniforms.time() * 3;
        float3 normal = geometry.normal();
        float factor = sin(geometry.vertex_id() + timeScaled);

        params.geometry().set_model_position_offset(normal * factor * 0.05 * progress);
    }
}
