//
//  Copyright © 2021 app|tects All rights reserved.
//

import RoomPlan
import UIKit

extension CapturedRoom {
    func export() {
        do {
            if let url = FileManager.getFilenameURL(for: UUID().uuidString, with: "usdz") {
                try export(to: url, exportOptions: [.mesh])
            }
        } catch {
            print(error.localizedDescription)
        }
    }

    var surfaces: [CapturedRoom.Surface] {
        doors + openings + walls + windows
    }

    var allIdentifiers: [String] {
        let surfaceIds = surfaces
            .map(\.identifier.uuidString)
        let objectIds = objects
            .map(\.identifier.uuidString)

        return surfaceIds + objectIds
    }
}

extension CapturedRoom.Surface.Category {
    var description: String {
        switch self {
            case .wall:
                return "Wall"
            case .opening:
                return "Opening"
            case .window:
                return "Window"
            case let .door(isOpen: isOpen):
                return "Door \(isOpen ? "(Open)" : "(Closed)")"
            @unknown default:
                return "?"
        }
    }

    var color: UIColor {
        UIColor.randomColor(seed: description).withAlphaComponent(0.7)
    }
}

extension CapturedRoom.Object.Category {
    var description: String {
        switch self {
            case .storage:
                return "Storage"
            case .refrigerator:
                return "Refrigerator"
            case .stove:
                return "Stove"
            case .bed:
                return "Bed"
            case .sink:
                return "Sink"
            case .washerDryer:
                return "Washer/Dryer"
            case .toilet:
                return "Toilet"
            case .bathtub:
                return "Bathtub"
            case .oven:
                return "Oven"
            case .dishwasher:
                return "Dishwasher"
            case .table:
                return "Table"
            case .sofa:
                return "Sofa"
            case .chair:
                return "Chair"
            case .fireplace:
                return "Fireplace"
            case .television:
                return "Television"
            case .stairs:
                return "Stairs"
            @unknown default:
                return "?"
        }
    }

    var color: UIColor {
        UIColor.randomColor(seed: description).withAlphaComponent(0.7)
    }
}

extension CapturedRoom.Confidence {
    var description: String {
        switch self {
            case .high:
                return "👍"
            case .medium:
                return "🤙"
            case .low:
                return "👎"
            @unknown default:
                return "?"
        }
    }
}
