//
//  Copyright © 2021 app|tects All rights reserved.
//

import RoomPlan
import SwiftUI

class NavigationModel: ObservableObject {
    public enum Views {
        case menu
        case notSupported
        case roomCapture
        case customRoomCapture
    }

    @Published var currentView: Views

    init() {
        currentView = RoomCaptureSession.isSupported ? .menu : .notSupported
    }
}
