//
//  Copyright © 2021 app|tects All rights reserved.
//

import SwiftUI

struct HoverInfo: Identifiable {
    let id: String
    let title: String
    let confidenceText: String
    let idText: String
    var screenPosition: CGPoint
    var isVisible: Bool
}

class RoomCaptureModel: ObservableObject {
    @Published var isCoachingEnabled = true
    @Published var isCaptureActive = false
    @Published var isModelVisible = true
    @Published var currentInstruction = ""
    @Published var hoverInfos: [HoverInfo] = .init()

    init(enableCoaching: Bool) {
        isCoachingEnabled = enableCoaching
    }
}
