//
//  Copyright © 2021 app|tects All rights reserved.
//

import SwiftUI

struct RoomCaptureContainerView<Content: View>: View {
    @EnvironmentObject var navigationModel: NavigationModel
    @EnvironmentObject var captureModel: RoomCaptureModel

    let content: Content

    init(@ViewBuilder content: () -> Content) {
        self.content = content()
    }

    var body: some View {
        ZStack {
            content
            HStack {
                Spacer()
                VStack {
                    Text(captureModel.currentInstruction)
                        .padding()
                        .background(.white)
                        .cornerRadius(5)
                        .isHidden(captureModel.isCoachingEnabled || captureModel.currentInstruction.isEmpty)
                    Spacer()
                }
                .padding(.top, 70)
                Spacer()
                VStack {
                    Button {
                        navigationModel.currentView = .menu
                    } label: {
                        Image(systemName: "x.circle.fill")
                    }
                    .buttonStyle(CustomButton())
                    .padding(.top, 30)
                    Spacer()
                    Button {
                        captureModel.isModelVisible.toggle()
                    } label: {
                        Image(systemName: captureModel.isModelVisible ? "eye.slash.fill" : "eye.fill")
                    }
                    .buttonStyle(CustomButton())
                    Button {
                        captureModel.isCaptureActive.toggle()
                    } label: {
                        Image(systemName: captureModel.isCaptureActive ? "stop.fill" : "play.fill")
                    }
                    .buttonStyle(CustomButton())
                }
            }
            ForEach(captureModel.hoverInfos) { hoverInfo in
                VStack {
                    Text(hoverInfo.title)
                        .font(.title3)
                        .bold()
                    Text(hoverInfo.confidenceText)
                        .font(.caption)
                    Text(hoverInfo.idText)
                        .font(.caption)
                }
                .padding()
                .background(.white)
                .cornerRadius(10)
                .position(x: hoverInfo.screenPosition.x,
                          y: hoverInfo.screenPosition.y)
                .isHidden(!hoverInfo.isVisible, remove: true)
            }
        }
    }

    struct CustomButton: ButtonStyle {
        func makeBody(configuration: Configuration) -> some View {
            configuration.label
                .frame(width: 50, height: 50)
                .background(.white)
                .foregroundColor(.blue)
                .clipShape(Circle())
                .padding(20)
        }
    }
}
