//
//  Copyright © 2021 app|tects All rights reserved.
//

import RoomPlan
import UIKit

class StandardRoomCaptureViewController: UIViewController {
    private var captureView: RoomCaptureView!
    private var config: RoomCaptureSession.Configuration = .init()
    private var coordinator: StandardRoomCaptureViewCoordinator

    init(coordinator: StandardRoomCaptureViewCoordinator, enableCoaching: Bool) {
        self.coordinator = coordinator
        config.isCoachingEnabled = enableCoaching
        super.init(nibName: nil, bundle: nil)
    }

    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    override func viewDidLoad() {
        captureView = RoomCaptureView(frame: view.bounds)
        captureView.delegate = coordinator
        captureView.isModelEnabled = true

        view.addSubview(captureView)
    }

    public var showModel: Bool {
        get {
            captureView.isModelEnabled
        }
        set {
            captureView.isModelEnabled = newValue
        }
    }

    public func start() {
        captureView.captureSession.run(configuration: config)
    }

    public func stop() {
        captureView.captureSession.stop()
    }
}
