//
//  Copyright © 2021 app|tects All rights reserved.
//

import Foundation

import Foundation

public extension FileManager {
    static func documentsDirectory() -> URL? {
        FileManager.default.urls(for: .documentDirectory, in: .userDomainMask).first
    }

    static func getFilenameURL(for filename: String, with fileExtension: String) -> URL? {
        documentsDirectory()?.appendingPathComponent(filename, isDirectory: false)
            .appendingPathExtension(fileExtension)
    }
}
