//
//  Copyright © 2021 app|tects All rights reserved.
//

import RoomPlan

extension RoomCaptureSession.Instruction {
    var description: String {
        switch self {
            case .moveCloseToWall:
                return "Move close to wall"
            case .moveAwayFromWall:
                return "Move away from wall"
            case .slowDown:
                return "Slow down"
            case .turnOnLight:
                return "Turn on light"
            case .normal:
                return ""
            case .lowTexture:
                return "Low Texture"
            @unknown default:
                return "?"
        }
    }
}
