//
//  Copyright © 2021 app|tects All rights reserved.
//

import SwiftUI

struct RootView: View {
    @EnvironmentObject var navigationModel: NavigationModel

    var body: some View {
        switch navigationModel.currentView {
            case .menu: menu
            case .notSupported: lidarUnavailable
            case .roomCapture: roomCaptureViewDemo
            case .customRoomCapture: customRoomCaptureView
        }
    }

    var menu: some View {
        VStack {
            Button {
                navigationModel.currentView = .roomCapture
            } label: {
                Text("RoomCaptureView Demo")
            }
            .padding()
            Button {
                navigationModel.currentView = .customRoomCapture
            } label: {
                Text("Custom Room Capture View")
            }
            .padding()
        }
    }

    private var lidarUnavailable: some View {
        NotSupportedView()
    }

    private var roomCaptureViewDemo: some View {
        RoomCaptureContainerView {
            StandardRoomCaptureView()
        }
        .environmentObject(RoomCaptureModel(enableCoaching: true))
        .ignoresSafeArea()
    }

    private var customRoomCaptureView: some View {
        RoomCaptureContainerView {
            CustomRoomCaptureView()
        }
        .environmentObject(RoomCaptureModel(enableCoaching: false))
        .ignoresSafeArea()
    }
}

struct RootView_Previews: PreviewProvider {
    static var previews: some View {
        RootView()
    }
}
