//
//  Copyright © 2021 app|tects All rights reserved.
//

import Combine
import RoomPlan
import SwiftUI

struct StandardRoomCaptureView: UIViewControllerRepresentable {
    @EnvironmentObject var captureModel: RoomCaptureModel

    func makeUIViewController(context: Context) -> StandardRoomCaptureViewController {
        let vc = StandardRoomCaptureViewController(coordinator: context.coordinator,
                                                   enableCoaching: captureModel.isCoachingEnabled)
        context.coordinator.viewController = vc
        return vc
    }

    func updateUIViewController(_ uiViewController: StandardRoomCaptureViewController,
                                context: Context) {}

    func makeCoordinator() -> StandardRoomCaptureViewCoordinator {
        StandardRoomCaptureViewCoordinator(captureModel: captureModel)
    }
}

class StandardRoomCaptureViewCoordinator {
    var viewController: StandardRoomCaptureViewController?

    private var captureModel: RoomCaptureModel
    private var subscriptions: Set<AnyCancellable> = .init()

    // swiftformat:disable:next initCoderUnavailable
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    func encode(with coder: NSCoder) {}

    init(captureModel: RoomCaptureModel) {
        self.captureModel = captureModel

        captureModel.$isCaptureActive.sink { captureActive in
            if captureActive {
                self.viewController?.start()
            } else {
                self.viewController?.stop()
            }
        }
        .store(in: &subscriptions)

        captureModel.$isModelVisible.sink { isVisible in
            self.viewController?.showModel = isVisible
        }
        .store(in: &subscriptions)
    }
}

// MARK: - RoomCaptureViewDelegate

extension StandardRoomCaptureViewCoordinator: RoomCaptureViewDelegate {
    func captureView(shouldPresent roomDataForProcessing: CapturedRoomData, error: Error?) -> Bool {
        if let error {
            print(error.localizedDescription)
        }

        print("*** roomDataForProcessing: \(roomDataForProcessing)")

        return true
    }

    func captureView(didPresent processedResult: CapturedRoom, error: Error?) {
        if let error {
            print(error.localizedDescription)
        }

        print("*** processedResult: \(processedResult)")

        processedResult.export()
    }
}
