//
// Topic.swift
//
// Copyright (c) 2023 by Simon Hartmann, Mark Zimmermann
//

import Foundation

class Topic: Codable, Identifiable {
    var id: UUID = .init()
    var startDate: Date?
    var endDate: Date?
    var minutes: Int
    var hours: Int
    var title: String

    var isActive: Bool {
        startDate != nil && endDate == nil
    }

    var isForthcoming: Bool {
        startDate == nil && endDate == nil
    }

    var duration: Measurement<UnitDuration> {
        .init(value: Double(minutes), unit: .minutes) + .init(value: Double(hours), unit: .hours)
    }

    static var new: Topic {
        Topic(hours: 0, minutes: 30, title: "TITEL")
    }

    init(hours: Int, minutes: Int, title: String, startDate: Date? = nil, endDate: Date? = nil) {
        self.hours = hours
        self.minutes = minutes
        self.title = title
        self.startDate = startDate
        self.endDate = endDate
    }

    func start() {
        startDate = .now
    }

    func end() {
        endDate = .now
    }

    func reset() {
        startDate = nil
        endDate = nil
    }

    func toLiveActivityModel() -> LiveActivityTopic {
        LiveActivityTopic(
            startDate: startDate,
            endDate: endDate,
            minutes: minutes,
            hours: hours,
            title: title
        )
    }
}
