//
// AgendaAttributes.swift
//
// Copyright (c) 2023 by Simon Hartmann, Mark Zimmermann
//

import ActivityKit
import Foundation

struct AgendaAttributes: ActivityAttributes {
    public struct ContentState: Codable, Hashable {
        var topic: LiveActivityTopic
    }

    let startDate: Date?
}

struct LiveActivityTopic: Codable, Hashable {
    var id: UUID = .init()
    let startDate: Date?
    let endDate: Date?
    let minutes: Int
    let hours: Int
    let title: String

    var plannedEndDate: Date! {
        startDate!.addingTimeInterval(Double(minutes * 60 + hours * 3600))
    }

    var duration: Measurement<UnitDuration> {
        .init(value: Double(minutes + hours * 60), unit: .minutes)
    }
}
