//
// EditTopicView.swift
//
// Copyright (c) 2023 by Simon Hartmann, Mark Zimmermann
//

import SwiftUI

struct EditTopicView: View {
    @EnvironmentObject var agenda: Agenda
    @Environment(\.dismiss) private var dismiss

    @State var title: String = ""
    @State private var hours: Int = 0
    @State private var minutes: Int = 30

    var body: some View {
        Form {
            Section("Titel") {
                TextField("Tagesordnungspunkt", text: $title)
            }

            Section("Dauer") {
                CustomDatePicker(hourSelection: $hours, minuteSelection: $minutes)
                    .frame(height: 150)
            }

            Button(
                action: {
                    agenda.addTopic(title: title, hours: hours, minutes: minutes)
                    dismiss.callAsFunction()
                },
                label: {
                    HStack {
                        Spacer()
                        Text("Speichern")
                            .bold()
                        Spacer()
                    }
                }
            )
            .listRowBackground(Color.blue)
            .foregroundColor(.white)
        }
        .navigationTitle("Tagesordnungspunkt")
        .background(Color(white: 0.95))
    }
}

struct AddTopicView_Previews: PreviewProvider {
    static var previews: some View {
        NavigationView {
            EditTopicView()
        }
    }
}
