//
// AgendaLiveActivity.swift
//
// Copyright (c) 2023 by Simon Hartmann, Mark Zimmermann
//

import ActivityKit
import SwiftUI
import WidgetKit

struct AgendaLiveActivity: Widget {
    var body: some WidgetConfiguration {
        ActivityConfiguration(for: AgendaAttributes.self) { context in
            HStack {
                VStack(alignment: .leading) {
                    Text(context.state.topic.title)
                        .font(.title3.bold())
                    Text(context.state.topic.duration.formatted())
                        .font(.title3)
                }

                Text(timerInterval: .now ... context.state.topic.plannedEndDate, countsDown: true)
                    .font(.largeTitle)
                    .multilineTextAlignment(.trailing)

                Link(destination: URL(string: "de.agendaapp://next")!) {
                    Image(systemName: "forward.fill")
                        .font(.title)
                        .foregroundColor(.white)
                }
            }
            .activityBackgroundTint(Color.cyan)
            .activitySystemActionForegroundColor(Color.black)
            .foregroundColor(.white)
            .padding()
        } dynamicIsland: { context in
            DynamicIsland {
                DynamicIslandExpandedRegion(.leading) {
                    VStack(alignment: .center) {
                        Image(systemName: "list.clipboard")
                            .font(.title.bold())
                            .padding(.bottom, 10)
                            .foregroundColor(.cyan)

                        Text(context.state.topic.title)
                    }
                }

                DynamicIslandExpandedRegion(.trailing) {
                    VStack(alignment: .trailing) {
                        Image(systemName: "timer")
                            .font(.title.bold())
                            .padding(.bottom, 10)
                            .foregroundColor(.cyan)

                        Text(timerInterval: .now ... context.state.topic.plannedEndDate)
                            .multilineTextAlignment(.center)
                    }
                }

                DynamicIslandExpandedRegion(.bottom) {
                    Link(destination: URL(string: "de.agendaapp://next")!) {
                        Label("Nächster Punkt", systemImage: "forward.fill")
                            .padding(.vertical, 10)
                            .padding(.horizontal, 30)
                            .background(.cyan.opacity(0.3))
                            .foregroundColor(.cyan)
                    }
                    .foregroundColor(.cyan)
                }
            } compactLeading: {
                CompactLeadingView(title: context.state.topic.title)
            } compactTrailing: {
                CompactTrailingView(endDate: context.state.topic.plannedEndDate)
            } minimal: {
                MinimalView(endDate: context.state.topic.plannedEndDate)
            }
        }
    }
}
