//
// Copyright (c) 2023 by Simon Hartmann, Mark Zimmermann
//

import Charts
import Foundation

struct PlottableLengthMeasurement: Plottable {
    var measurement: Measurement<UnitLength>

    var primitivePlottable: Double {
        measurement.converted(to: .millimeters).value
    }

    init(of: Measurement<UnitLength>) {
        measurement = of
    }

    init?(primitivePlottable: Double) {
        measurement = Measurement(value: primitivePlottable, unit: .millimeters)
    }
}
