//
// Copyright (c) 2023 by Simon Hartmann, Mark Zimmermann
//

import Charts
import Foundation

struct PlottableTemperatureMeasurement: Plottable {
    var measurement: Measurement<UnitTemperature>

    var primitivePlottable: Double {
        measurement.converted(to: .celsius).value
    }

    init(of: Measurement<UnitTemperature>) {
        measurement = of
    }

    init?(primitivePlottable: Double) {
        measurement = Measurement(value: primitivePlottable, unit: .celsius)
    }
}
